# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.family.forms import FamilyInvitesInfoForm
from passport.backend.api.views.bundle.mixins import (
    BundleAccountGetterMixin,
    BundleFamilyMixin,
)


class InvitesInfoView(
    BaseBundleView,
    BundleFamilyMixin,
    BundleAccountGetterMixin,
):
    basic_form = FamilyInvitesInfoForm

    required_grants = ['family.invites_info']

    def fill_response_with_family_invites(self):
        self.response_values['family_invites'] = [
            self.family_invite_to_response(invite)
            for invite in self.family_invites
        ]

    def family_invite_to_response(self, invite):
        return {'invite_id': invite.invite_id}

    def process_request(self):
        self.process_basic_form()

        self.get_account_by_uid(self.form_values['uid'], get_family_info=True)

        self.assert_is_family_admin()

        self.load_family_invites_by_family_id(
            self.account.family_info.family_id,
        )

        self.fill_response_with_family_settings()
        self.fill_response_with_family_invites()
