# -*- coding: utf-8 -*-

"""Список хедеров для использования с BaseBundleView.check_headers()
"""

from collections import namedtuple


Header = namedtuple('Header', ['name', 'code_for_error', 'allow_empty_value'])


HEADER_CONSUMER_CLIENT_IP = Header(
    name='Ya-Consumer-Client-Ip',
    code_for_error='ip',
    allow_empty_value=False,
)
HEADER_CONSUMER_REAL_IP = Header(
    name='Ya-Consumer-Real-Ip',
    code_for_error='real_ip',
    allow_empty_value=False,
)
HEADER_CONSUMER_AUTHORIZATION = Header(
    name='Ya-Consumer-Authorization',
    code_for_error='authorization',
    allow_empty_value=True,
)
HEADER_CLIENT_HOST = Header(
    name='Ya-Client-Host',
    code_for_error='host',
    allow_empty_value=False,
)
HEADER_CLIENT_COOKIE = Header(
    name='Ya-Client-Cookie',
    code_for_error='cookie',
    allow_empty_value=True,
)
HEADER_CLIENT_USER_AGENT = Header(
    name='Ya-Client-User-Agent',
    code_for_error='useragent',
    allow_empty_value=True,
)
HEADER_CLIENT_REFERER = Header(
    name='Ya-Client-Referer',
    code_for_error='referer',
    allow_empty_value=True,
)
HEADER_CLIENT_ACCEPT_LANGUAGE = Header(
    name='Ya-Client-Accept-Language',
    code_for_error='accept_language',
    allow_empty_value=True,
)
HEADER_CLIENT_X_FORWARDED_FOR = Header(
    name='Ya-Client-X-Forwarded-For',
    code_for_error='x_forwarded_for',
    allow_empty_value=True,
)
HEADER_CLIENT_X_REQUEST_ID = Header(
    name='Ya-Client-X-Request-Id',
    code_for_error='request_id',
    allow_empty_value=False,
)


AUTHORIZATION_HEADERS = {HEADER_CLIENT_HOST, HEADER_CLIENT_COOKIE, HEADER_CONSUMER_CLIENT_IP}


__all__ = (
    'HEADER_CONSUMER_CLIENT_IP',
    'HEADER_CONSUMER_REAL_IP',
    'HEADER_CONSUMER_AUTHORIZATION',
    'HEADER_CLIENT_HOST',
    'HEADER_CLIENT_COOKIE',
    'HEADER_CLIENT_USER_AGENT',
    'HEADER_CLIENT_REFERER',
    'HEADER_CLIENT_ACCEPT_LANGUAGE',
    'HEADER_CLIENT_X_FORWARDED_FOR',
    'HEADER_CLIENT_X_REQUEST_ID',

    'AUTHORIZATION_HEADERS',
)
