# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class AccountDeletionFailed(BaseBundleError):
    error = 'account_deletion.failed'


class AccountDeletionTemporaryError(BaseBundleError):
    error = 'account_deletion.temporary_error'


class AccountNotTestAccountError(BaseBundleError):
    error = 'account.not_test_account'


class PhoneNotFoundError(BaseBundleError):
    """У аккаунта нет привязанного номера телефона"""
    error = 'phone.not_found'


class PhoneNotTestNumberError(BaseBundleError):
    error = 'phone.not_test_number'


class PhoneNotUpdatableError(BaseBundleError):
    error = 'phone.not_updatable'


class SecurePhoneBoundAndConfirmedError(BaseBundleError):
    error = 'phone_secure.bound_and_confirmed'


class SecurePhoneAlreadyExistsError(BaseBundleError):
    error = 'phone_secure.already_exists'


class AttributeMustBeNull(BaseBundleError):
    def __init__(self, attr):
        self.error = '%s.must_be_null' % attr


class AttributeMustBeLessOrEqualThan(BaseBundleError):
    def __init__(self, lesser_attr, greater_attr):
        self.error = '%s.must_be_less_or_equal_than_%s' % (lesser_attr, greater_attr)


class EmailNotUpdatableError(BaseBundleError):
    error = 'email.not_updatable'
