# -*- coding: utf-8 -*-

from passport.backend.api.forms import UidForm
from passport.backend.core import validators
from passport.backend.core.types.account.account import ACCOUNT_TYPE_LITE


class ConfirmAndBindPhoneForm(validators.Schema):
    uid = validators.Uid()
    password = validators.String(not_empty=True)
    number = validators.String(not_empty=True, strip=True)
    secure = validators.StringBool(not_empty=True, strip=True)


class LiteAccountRegisterForm(validators.Schema):
    login = validators.LiteLogin(not_empty=True)
    password = validators.String(not_empty=True)

    firstname = validators.FirstName(if_missing=None, if_empty='')
    lastname = validators.LastName(if_missing=None, if_empty='')

    chained_validators = [
        validators.Availability(login_type=ACCOUNT_TYPE_LITE),
    ]


class TotpEditForm(UidForm):
    totp_secret = validators.String(not_empty=True)


class SaveTrackForm(validators.Schema):
    allow_authorization = validators.StringBool(if_missing=None, not_empty=False, strip=True)
    antifraud_tags = validators.JSONValidator(if_missing=[], not_empty=False, strip=True)
    is_auth_challenge_shown = validators.StringBool(if_missing=None, not_empty=False, strip=True)
    payment_status = validators.String(if_missing=None, strip=True)

    chained_validators = [
        validators.RequireSome([
            'allow_authorization',
            'antifraud_tags',
            'is_auth_challenge_shown',
            'payment_status',
        ], min_=1, max_=4),
    ]


class SetPasswordForm(validators.Schema):
    uid = validators.Uid()
    password = validators.String(not_empty=True, if_missing=None)


class DeleteYakeyBackupForm(validators.Schema):
    number = validators.String(not_empty=True, strip=True)
    country = validators.CountryCode(if_missing=None, not_empty=True)

    chained_validators = [
        validators.PhoneNumber(phone_number_key='number'),
    ]


class UpdatePhoneForm(validators.Schema):
    uid = validators.Uid()
    phone_id = validators.PhoneId()
    created = validators.Unixtime(if_missing=None)
    bound = validators.Unixtime(if_missing=None)
    secured = validators.Unixtime(if_missing=None)
    admitted = validators.Unixtime(if_missing=None)
    confirmed = validators.Unixtime(if_missing=None)


class UpdateEmailForm(validators.Schema):
    uid = validators.Uid()
    email = validators.ComprehensiveEmailValidator()
    created_at = validators.Unixtime(if_missing=None)
    bound_at = validators.Unixtime(if_missing=None)
    confirmed_at = validators.Unixtime(if_missing=None)


class UpdateAccountDeletionOperationForm(validators.Schema):
    uid = validators.Uid()
    started_at = validators.Unixtime(if_missing=None)


class UpdateAccountRegistrationDatetimeForm(validators.Schema):
    uid = validators.Uid()
    registration_datetime = validators.Unixtime()


class LogbrokerTestForm(validators.Schema):
    id = validators.Int(not_empty=True)
    test_data = validators.String(if_empty='')
    sub_message_int = validators.Int(if_empty=0)
    sub_message_str = validators.String(if_empty='')


class AmPushMessageTestForm(validators.Schema):
    uid = validators.Uid()
    push_service = validators.Regex(r'^[a-zA-Z0-9_]+$', not_empty=True)
    event_name = validators.Regex(r'^[a-zA-Z0-9_]+$', not_empty=True)
    app_targeting_type = validators.OneOf([
        'GLOBAL', 'GLOBAL_WITH_CAPS', 'ONE_APP_PER_DEVICE', 'CLIENT_DECIDES',
    ], if_missing='GLOBAL')
    custom_app_priority = validators.ListValidator(
        validators.Regex(r'^[a-zA-Z0-9._-]+$'),
        if_missing=None,
    )
    am_capabilities = validators.ListValidator(
        validators.Regex(r'^[a-zA-Z0-9_]+$'),
        if_missing=None,
    )
    required_platforms = validators.ListValidator(
        validators.OneOf(['android', 'ios']),
        if_missing=None,
    )
    device_ids = validators.ListValidator(
        validators.String(not_empty=True),
        if_missing=None,
    )
    title = validators.String()
    body = validators.String(if_missing=None)
    subtitle = validators.String(if_missing=None)
    webview_url = validators.SimpleUrlValidator(if_missing=None)
    require_web_auth = validators.StringBool(if_missing=True)
    push_id = validators.String(if_missing=None)
