# -*- coding: utf-8 -*-
from passport.backend.core.encrypted_container import BaseEncryptedContainer


MDA2_CONTAINER_TYPE = 'mda2_container'
MDA2_CONTAINER_SIGN_SPACE = 'mda2_container'
MDA2_CONTAINER_TTL = 60


class MDA2Container(BaseEncryptedContainer):
    type_to_ttl = {
        MDA2_CONTAINER_TYPE: MDA2_CONTAINER_TTL,
    }
    type_to_sign_space = {
        MDA2_CONTAINER_TYPE: MDA2_CONTAINER_SIGN_SPACE,
    }
    default_type = MDA2_CONTAINER_TYPE
