# -*- coding: utf-8 -*-
from passport.backend.core import validators


class BaseMda2Form(validators.Schema):
    is_background = validators.StringBool(if_missing=False)
    process_uuid = validators.String(not_empty=True)


class BuildContainerForm(BaseMda2Form):
    target_host = validators.Hostname(not_empty=True)


class UseContainerForm(BaseMda2Form):
    retpath = validators.RetPath(if_missing=None, if_empty=None)
    container = validators.String(not_empty=True)

    chained_validators = [
        validators.RequireIfEquals(['retpath'], 'is_background', False),
    ]
