# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.auth.base import BundleBaseAuthorizationMixin
from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.api.views.bundle.mixins import BundleAccountGetterMixin
from passport.backend.core.logging_utils.loggers.statbox import StatboxLogger
from passport.backend.core.models.domain import Domain
from passport.backend.core.utils.decorators import cached_property

from .exceptions import DomainNotFoundError


class BasePddView(BaseBundleView,
                  BundleBaseAuthorizationMixin,
                  BundleAccountGetterMixin):
    require_track = False

    def get_domain(self, domain_or_id, aliases=False):
        """
        Получаем информацию о домене по его ID или имени домена.
        """
        kwargs = dict(aliases=aliases)
        try:
            kwargs['domain_id'] = int(domain_or_id)
        except ValueError:
            kwargs['domain'] = domain_or_id

        domains = self.blackbox.hosted_domains(**kwargs)
        if not domains['hosted_domains']:
            raise DomainNotFoundError()
        return Domain().parse(domains['hosted_domains'][0])

    @cached_property
    def statbox(self):
        return StatboxLogger(
            mode='mdapi',
            consumer=self.consumer,
            ip=self.client_ip,
            user_agent=self.user_agent,
        )
