# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.exceptions import BaseBundleError


class DomainAlreadyExistsError(BaseBundleError):
    """Создаваемый ПДД-домен уже существует"""
    error = 'domain.already_exists'


class DomainUsersRemainingError(BaseBundleError):
    """У удаляемого домена ПДД все ещё существуют пользователи"""
    error = 'domain.users_remaining'


class DomainNotFoundError(BaseBundleError):
    """Искомый ПДД-домен не найден"""
    error = 'domain.not_found'


class DomainMasterIsAliasError(BaseBundleError):
    """Домен, к которому привязывается алиас сам является алиасом"""
    error = 'domain.master_is_alias'


class DomainAliasAlreadyExistsError(BaseBundleError):
    """Создаваемый алиас для ПДД-домена уже существует"""
    error = 'domain_alias.exists'


class DomainAliasNotFoundError(BaseBundleError):
    """Искомый алиас для ПДД-домена не найден"""
    error = 'domain_alias.not_found'
