# -*- coding: utf-8 -*-
from passport.backend.core import validators


class PddAddDomainForm(validators.Schema):
    """Форма создания нового ПДД-домена"""
    domain = validators.Hostname(not_empty=True, reject_native=True)
    # UID пользователя, ответственного за управление доменом
    admin_uid = validators.Uid(not_empty=True)
    # Флаг расположения MX записей домена на серверах Яндекса
    mx = validators.StringBool(if_missing=False)
    # Флаг состояния домена
    enabled = validators.StringBool(if_missing=True)


class PddEditDomainForm(validators.Schema):
    """Форма редактирования ПДД-домена"""
    # UID пользователя, ответственного за управление доменом
    admin_uid = validators.Uid(if_missing=None)
    # Флаг расположения MX записей домена на серверах Яндекса
    mx = validators.StringBool(if_missing=None)
    # Флаг состояния домена
    enabled = validators.StringBool(if_missing=None)
    # Пользователь, получающий все письма без адресата для домена
    default = validators.String(if_missing=None)
    # Флаг возможности пользователям выставлять свои пароли
    can_users_change_password = validators.StringBool(if_missing=None)
    # ID домена, который будет отображаться у пользователей в display_name
    # Удаляем, если передали пустое значение
    display_master_id = validators.DomainId(if_missing=None, not_empty=False, if_empty=0)
    # Имя организации для Яндекс.Workspace
    # Удаляем, если передали пустое значение
    organization_name = validators.String(if_missing=None, strip=True)
    # Если true, то глогаутим всех пользователей на домене
    glogouted = validators.StringBool(if_missing=None)
    # ID редактируемого домена
    domain_id = validators.DomainId()


class PddDeleteDomainForm(validators.Schema):
    """Форма удаления ПДД-домена"""
    # ID удаляемого домена
    domain_id = validators.DomainId()


class PddAddDomainAliasForm(validators.Schema):
    """Форма создания алиаса ПДД-домена"""
    # ID головного домена
    domain_id = validators.DomainId()
    # Имя создаваемого алиаса
    alias = validators.Hostname(not_empty=True, reject_native=True)


class PddDeleteDomainAliasForm(validators.Schema):
    """Форма удаления алиаса ПДД-домена"""
    # ID головного домена
    domain_id = validators.DomainId()
    # ID удаляемого алиаса
    alias_id = validators.DomainId()


class PddAliasToMasterForm(validators.Schema):
    """Форма обмена алиаса ПДД-домена с головным доменом"""
    # ID текущего головного домена
    domain_id = validators.DomainId()
    # ID алиаса
    alias_id = validators.DomainId()
