# -*- coding: utf-8 -*-

import logging

from passport.backend.api.views.bundle.exceptions import ValidationFailedError
from passport.backend.core import validators
from passport.backend.core.models.password import PASSWORD_ENCODING_VERSION_MD5_CRYPT_ARGON


log = logging.getLogger(__name__)


class BundleScholarMixin(object):
    def set_scholar_password(self, password):
        self.account.scholar_password.set(
            get_hash_from_blackbox=True,
            password=password,
            version=PASSWORD_ENCODING_VERSION_MD5_CRYPT_ARGON,
        )

    def validate_scholar_password(self):
        try:
            validators.Password(
                required_check_password_pwned=False,
                required_password_quality=False,
            ).to_python(
                dict(
                    password=self.form_values.get('password'),
                    policy='scholar',
                ),
            )
        except validators.Invalid as e:
            validation_failed = ValidationFailedError.from_invalid(e)
            log.info('Password validation: status=error errors=%s' % ','.join(validation_failed.errors))
            raise validation_failed
