# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class NativeActionRequiredError(BaseBundleError):
    """Для продолжения нужен дополнительный шаг в рамках текущего процесса. Подробности - в поле ответа state."""
    error = 'action.required_native'


class ExternalOrNativeActionRequiredError(BaseBundleError):
    """
    Для продолжения нужен дополнительный шаг (в рамках текущего процесса или вне его).
    Подробности - в поле ответа state.
    """
    error = 'action.required_external_or_native'


class MagicLinkNotConfirmedError(BaseBundleError):
    """Пользователь не подтвердил емейл магической ссылкой"""
    error = 'magic_link.not_confirmed'
