# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.mixins.challenge import MobilePasswordSource
from passport.backend.core import validators


class BaseStartForm(validators.Schema):
    avatar_size = validators.String(if_missing=None, strip=True)
    captcha_scale_factor = validators.Int(if_missing=None, min=1, max=3)
    payment_auth_retpath = validators.String(if_missing=None)
    display_language = validators.CaptchaDisplayLanguage(not_empty=True)
    cloud_token = validators.String(if_missing=None, strip=True)

    x_token_client_id = validators.String(not_empty=True, strip=True)
    x_token_client_secret = validators.String(not_empty=True, strip=True)

    client_id = validators.String(if_missing=None, if_empty=None, strip=True)
    client_secret = validators.String(if_missing=None, if_empty=None, strip=True)

    force_register = validators.StringBool(if_missing=False, not_empty=True, strip=True)


class StartV1Form(BaseStartForm):
    login = validators.LooseLoginValidator(not_empty=False, if_missing=None, if_empty=None)
    phone_number = validators.String(if_missing=None, if_empty=None, strip=True)

    chained_validators = [
        validators.RequireSet([('client_id', 'client_secret')], allow_empty=True),
        validators.RequireSome(['login', 'phone_number'], min_=1, max_=1),
    ]


class StartForm(BaseStartForm):
    login = validators.LooseLoginValidator()
    is_phone_number = validators.StringBool(if_missing=False, not_empty=True, strip=True)
    old_track_id = validators.TrackId(if_missing=None)

    chained_validators = [
        validators.RequireSet([('client_id', 'client_secret')], allow_empty=True),
    ]


class PasswordForm(validators.Schema):
    password = validators.String(not_empty=True, strip=True)
    captcha_answer = validators.String(if_missing=None, max=100)
    password_source = validators.AnyOfStringsOrEmptyValidator(
        allowed_values=MobilePasswordSource.all_sources,
        if_missing=None,
        strip=True,
    )
    avatar_url = validators.SimpleUrlValidator(strip=True, if_missing=None)


class RfcOtpForm(validators.Schema):
    rfc_otp = validators.String(not_empty=True, strip=True)
    captcha_answer = validators.String(if_missing=None, max=100)


class PhoneNumberForm(validators.Schema):
    phone_number = validators.String(not_empty=True, strip=True)
    validate_for_call = validators.StringBool(if_empty=True, if_missing=False, strip=True)


class AuthAfterLoginRestoreForm(validators.Schema):
    uid = validators.Uid()
    firstname = validators.FirstName(not_empty=True)
    lastname = validators.LastName(not_empty=True)


class MobileRegisterForm(validators.Schema):
    login = validators.Login()
    password = validators.String(not_empty=True)

    force_clean_web = validators.StringBool(if_missing=False, strip=True)
    firstname = validators.AntiFraudFirstName(not_empty=True)
    lastname = validators.AntiFraudLastName(not_empty=True)

    eula_accepted = validators.StringBool(not_empty=True, strip=True)

    unsubscribe_from_maillists = validators.StringBool(if_missing=False)

    chained_validators = [
        validators.Availability(),
    ]


class MobileRegisterLiteForm(validators.Schema):
    password = validators.String(if_missing=None)

    force_clean_web = validators.StringBool(if_missing=False, strip=True)
    firstname = validators.AntiFraudFirstName(if_missing=None)
    lastname = validators.AntiFraudLastName(if_missing=None)

    eula_accepted = validators.StringBool(not_empty=True, strip=True)

    unsubscribe_from_maillists = validators.StringBool(if_missing=False)


class MobileRegisterNeophonishForm(validators.Schema):
    force_clean_web = validators.StringBool(if_missing=False, strip=True)
    firstname = validators.AntiFraudFirstName(not_empty=True)
    lastname = validators.AntiFraudLastName(not_empty=True)

    eula_accepted = validators.StringBool(not_empty=True, strip=True)

    unsubscribe_from_maillists = validators.StringBool(if_missing=False)


class MagicLinkSendForm(validators.Schema):
    retpath = validators.RetPath(if_missing=None)
