# -*- coding: utf-8 -*-
from passport.backend.api.forms.base import DeviceInfoForm
from passport.backend.core import validators


class ClientEditedForm(validators.Schema):
    uid = validators.Uid(not_empty=True, if_missing=None)
    client_id = validators.String(not_empty=True, strip=True)
    client_title = validators.String(not_empty=True, strip=True)
    redirect_uris_changed = validators.StringBool(if_missing=False)
    scopes_changed = validators.StringBool(if_missing=False)


class DeviceAuthorizeSubmitOrCommitForm(DeviceInfoForm):
    uid = validators.Uid(not_empty=True, if_missing=None)
    language = validators.PortalLanguage()
    code = validators.String(not_empty=True, strip=True)


class TokenBySessionidForm(validators.Schema):
    client_id = validators.String(not_empty=True)
    client_secret = validators.String(not_empty=True)
    uid = validators.Uid(not_empty=True, if_missing=None)
