# -*- coding: utf-8 -*-
from passport.backend.api.common.account import default_revokers
from passport.backend.api.views.bundle.mixins import BundleFixPDDRetpathMixin
from passport.backend.core import validators

from .base import OtpDisableBase


class OtpDisableSubmitForm(validators.Schema):
    origin = validators.String(if_missing=None, not_empty=False, strip=True)
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)


class OtpDisableSubmitView(OtpDisableBase, BundleFixPDDRetpathMixin):

    require_track = False

    basic_form = OtpDisableSubmitForm

    def process(self):
        self.process_basic_form()
        self.get_account_from_session(
            check_disabled_on_deletion=True,
        )
        self.assert_otp_is_enabled()
        self.create_track(self.track_type)
        with self.track_transaction.commit_on_error():
            self.track.uid = self.account.uid
            self.track.is_it_otp_disable = True
            # для ввода одноразового пароля возможно применение "магии"
            self.track.is_allow_otp_magic = True

            self.track.origin = self.form_values['origin']
            if self.form_values['retpath']:
                self.track.retpath = self.form_values['retpath']
                if self.account.is_pdd:
                    self.fix_pdd_retpath()

        self.fill_response_with_account(personal_data_required=True)
        self.statbox.log(action='submitted')
        self.response_values['track_id'] = self.track_id
        self.response_values['revokers'] = default_revokers(
            allow_select=not self.account.is_strong_password_required,
        )
