# -*- coding: utf-8 -*-

from passport.backend.core import validators


class OtpEnableSubmitForm(validators.Schema):
    origin = validators.String(if_missing=None, not_empty=False, strip=True)
    retpath = validators.RetPath(if_missing=None, ignore_invalid=True, not_empty=False)
    session_reissue_interval = validators.Int(not_empty=False, if_missing=None)


class OtpEnableSetPinForm(validators.Schema):

    pin = validators.String(not_empty=True)


class OtpEnableCheckOtpForm(validators.Schema):

    otp = validators.String(not_empty=True)


class OtpEnableSaveDeviceForm(validators.Schema):
    device_id = validators.DeviceId()
    push_setup_secret = validators.String(not_empty=True, strip=True)
