# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.mixins.account import BundleAccountResponseRendererMixin
from passport.backend.api.views.bundle.phone.helpers import dump_number
from passport.backend.core.types.totp_secret import TotpSecretType

from .base import OtpEnableBase


class OtpEnableGetStateView(OtpEnableBase, BundleAccountResponseRendererMixin):

    require_track = True

    sensitive_fields = [
        'pin',
        'app_secret',
        'app_secret_container',
    ]

    def process(self):

        self.read_track()
        self.response_values['track_id'] = self.track_id
        # фронт требует retpath, даже если случится ошибка
        self.response_values['retpath'] = self.track.retpath
        self.check_track()

        self.get_account()
        self.assert_otp_is_disabled()
        self.response_values['secure_number'] = dump_number(self.secure_number) if self.secure_number else None

        if self.track.totp_app_secret:
            totp_secret = TotpSecretType.build(self.track.totp_app_secret, self.track.totp_pin)
            self.response_values.update(
                pin=totp_secret.pin,
                app_secret=totp_secret.human_readable_app_secret,
                pin_length=len(totp_secret.pin),
                app_secret_container=totp_secret.build_container_for_yakey(uid=int(self.track.uid)),
                sensitive_fields=self.sensitive_fields,
            )

        self.response_values['is_password_required'] = False
        self.response_values['is_otp_checked'] = bool(self.track.is_otp_checked)
        self.response_values['skip_phone_check'] = bool(self.track.is_otp_restore_passed)
        self.fill_response_with_account()
