# -*- coding: utf-8 -*-
import logging

from passport.backend.api.views.bundle.exceptions import (
    InvalidCSRFTokenError,
    InvalidTrackStateError,
)
from passport.backend.api.views.bundle.otp.enable.forms import OtpEnableSaveDeviceForm

from .base import OtpEnableBase


log = logging.getLogger('passport.api.view.bundle.otp.save_device')

TRACK_DEVICES_LIMIT = 30


class OtpEnableSaveDeviceView(OtpEnableBase):

    require_track = True
    basic_form = OtpEnableSaveDeviceForm

    def check_track(self):
        super(OtpEnableSaveDeviceView, self).check_track()
        if not (self.track.totp_app_secret and self.track.totp_pin and self.track.push_setup_secret):
            raise InvalidTrackStateError()
        if self.track.push_setup_secret != self.form_values['push_setup_secret']:
            raise InvalidCSRFTokenError()
        if len(list(self.track.totp_push_device_ids.get())) >= TRACK_DEVICES_LIMIT:
            log.debug('Too many push device ids in the track')
            raise InvalidTrackStateError()

    def process(self):
        self.read_track()
        self.process_basic_form()
        self.response_values['track_id'] = self.track_id
        self.check_track()

        if self.form_values['device_id'] not in self.track.totp_push_device_ids.get():
            with self.track_transaction.commit_on_error():
                self.track.totp_push_device_ids.append(self.form_values['device_id'])
