# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.exceptions import InvalidTrackStateError
from passport.backend.api.views.bundle.mixins.password import BundlePinValidationMixin

from .base import OtpEnableBase
from .forms import OtpEnableSetPinForm


class OtpEnableSetPinView(OtpEnableBase, BundlePinValidationMixin):

    basic_form = OtpEnableSetPinForm

    require_track = True

    sensitive_fields = [
        'pin',
    ]

    def check_track(self):
        super(OtpEnableSetPinView, self).check_track()
        if not self.is_phone_confirmed_in_track():
            raise InvalidTrackStateError('Phone on this track was not confirmed')
        if not (self.track.totp_app_secret and self.track.totp_pin):
            raise InvalidTrackStateError('Secret was not generated')
        if self.track.is_otp_checked:
            # Нельзя менять пин, когда уже проверили отп
            raise InvalidTrackStateError('Otp already checked')

    def process(self):
        self.process_basic_form()
        self.read_track()
        self.response_values['track_id'] = self.track_id
        self.check_track()
        pin = self.validate_pin(pin=self.form_values['pin'])

        self.get_account()

        self.assert_otp_is_disabled()
        self.assert_secure_phone_exist_and_confirmed()

        with self.track_transaction.rollback_on_error():
            self.track.totp_pin = pin

        self.response_values.update(
            sensitive_fields=self.sensitive_fields,
        )
