# -*- coding: utf-8 -*-

from passport.backend.api.forms import (
    ConsumerForm,
    DeviceInfoForm,
    TrackedConsumerForm,
)
from passport.backend.core import validators


class ShortInfoForm(DeviceInfoForm):
    consumer = validators.Consumer()
    track_id = validators.TrackId(if_missing=None)
    login = validators.String(not_empty=True)
    avatar_size = validators.String(if_missing=None, strip=True)


class OtpPrepareAuthForm(TrackedConsumerForm):
    otp = validators.String(not_empty=True)
    login = validators.String(not_empty=True)
    selected_2fa_picture = validators.Int(if_missing=None)


class OtpSetCheckTimeForm(ConsumerForm):
    uid = validators.Uid()
    totp_check_time = validators.Int(if_missing=None, not_empty=True, strip=True)
