# -*- coding: utf-8 -*-
from passport.backend.core.types.totp_secret import TotpSecretType

from .base import BaseOtpMigrateView


class OtpMigrateGetSecretView(BaseOtpMigrateView):

    def process(self):
        if not self.track.totp_app_secret:
            with self.track_transaction.rollback_on_error():
                totp_secret = TotpSecretType.generate()
                self.track.totp_app_secret = totp_secret.human_readable_app_secret
        else:
            totp_secret = TotpSecretType.build(
                self.track.totp_app_secret,
                '0' * self.account.totp_secret.pin_length,  # реальный пин не важен, важна длина
            )

        self.response_values.update(
            app_secret=totp_secret.human_readable_app_secret,
            pin_length=self.account.totp_secret.pin_length,
            app_secret_container=totp_secret.build_container_for_yakey(uid=int(self.track.uid)),
            sensitive_fields=['app_secret', 'app_secret_container'],
        )
