# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.mixins import (
    BundleAccountResponseRendererMixin,
    BundleFixPDDRetpathMixin,
)

from .base import BaseOtpMigrateView
from .forms import OtpMigrateSubmitForm


class OtpMigrateSubmitView(BaseOtpMigrateView,
                           BundleAccountResponseRendererMixin,
                           BundleFixPDDRetpathMixin):

    basic_form = OtpMigrateSubmitForm

    def process(self):
        self.process_basic_form()

        with self.track_transaction.rollback_on_error():
            self.track.is_it_otp_enable = True
            if self.form_values['retpath']:
                self.track.retpath = self.form_values['retpath']
                if self.account.is_pdd:
                    self.fix_pdd_retpath()

        self.fill_response_with_account(personal_data_required=True)
        self.statbox.log(action='submitted')
