# -*- coding: utf-8 -*-
import logging

from passport.backend.api.views.bundle.exceptions import InvalidTrackStateError
from passport.backend.api.views.bundle.mixins import KolmogorMixin
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers.statbox import StatboxLogger
from passport.backend.core.utils.decorators import cached_property
from passport.backend.utils.time import get_unixtime

from .base import BaseBundleAppView


log = logging.getLogger('passport.otp.not_me')


class OtpNotMeView(BaseBundleAppView, KolmogorMixin):

    require_track = True

    track_type = 'authorize'

    required_grants = ['otp.app']

    @cached_property
    def statbox(self):
        return StatboxLogger(
            track_id=self.track.track_id,
            ip=self.client_ip,
        )

    @cached_property
    def yakey_2fa_pictures_deny_flag_counter(self):
        return self.build_counter(
            keyspace=settings.YAKEY_2FA_PICTURES_SHOWN_KEYSPACE,
            name=settings.YAKEY_2FA_PICTURES_DENY_FLAG_COUNTER % self.track.uid,
            limit=1,
        )

    def process_request(self):
        self.read_track()
        if not (
            self.track.track_type == self.track_type and
            self.track.is_allow_otp_magic and
            self.track.correct_2fa_picture and
            self.track.correct_2fa_picture_expires_at
        ):
            raise InvalidTrackStateError()

        with self.track_transaction.commit_on_error():
            self.track.correct_2fa_picture_expires_at = get_unixtime()

        self.kolmogor_toolkit.inc_counters([self.yakey_2fa_pictures_deny_flag_counter])

        self.statbox.log(action='otp_auth_user_denied')
