# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.base import BaseBundleView
from passport.backend.core.models.account import Account
from passport.backend.core.models.totp_secret import TotpSecret
from passport.backend.core.runner.context_managers import UPDATE

from .forms import OtpSetCheckTimeForm


class OtpSetCheckTimeView(BaseBundleView):

    require_track = False

    required_grants = ['otp.set_check_time']

    basic_form = OtpSetCheckTimeForm

    def process_request(self, *args, **kwargs):
        self.process_basic_form()

        # Соберём фейковый аккаунт, чтобы не читать его из ЧЯ
        # (ЧЯ мы безгранично доверяем: уверены, что нам передали уид существующего
        # аккаунта с включённой 2fa)
        account = Account(uid=self.form_values['uid'])
        account.password = None  # FIXME: костыль, нужно для fix_passport_login_rule
        account.totp_secret = TotpSecret(parent=account)

        # И запишем totp_secret.check_time в БД
        events = {'action': 'set_totp_check_time'}
        with UPDATE(account, self.request.env, events, disable_history_db=True):
            account.totp_secret.check_time = self.form_values['totp_check_time']
