# -*- coding: utf-8 -*-

from passport.backend.core import validators

from .forms import (
    AccountedNumberedSubmitForm,
    BaseCommitForm,
)


class AccountedCommitForm(BaseCommitForm):
    uid = validators.Uid(if_missing=None, not_empty=True)


class PasswordedCommitForm(AccountedCommitForm):
    """Форма для ручек commit, где требуется указание пароля аккаунта."""
    password = validators.String(not_empty=True, if_missing=None)


class BindOrConfirmBoundSubmitForm(AccountedNumberedSubmitForm):
    pass


class BindOrConfirmBoundCommitForm(AccountedCommitForm):
    pass


class BindPhoneFromPhonishToPortalForm(validators.Schema):
    portal_uid = validators.Uid()
    phonish_uid = validators.Uid()
