# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import ActionImpossibleError
from passport.backend.api.views.bundle.internal.exceptions import PhoneNotFoundError
from passport.backend.core.models.phones.phones import (
    NumberNotBound,
    OperationInapplicable,
    SecureNumberBoundAlready,
    SecurifyOperation,
    SingleSecureOperationError,
)
from passport.backend.core.runner.context_managers import UPDATE

from .. import forms
from ..base import (
    BasePhoneManageBundleView,
    BASIC_GRANT,
)


SUDO_GRANT = 'phone_bundle.securify_sudo'


class SecurifySudoPhone(BasePhoneManageBundleView):
    basic_form = forms.SecurifySudoForm
    required_grants = [BASIC_GRANT, SUDO_GRANT]
    require_track = False
    step = 'sudo'

    def process_request(self):
        self.process_basic_form()

        self.get_account_by_uid(self.form_values['uid'], need_phones=True)
        self._load_phone_by_id(self.form_values['phone_id'])

        events = {'action': 'securify_sudo', 'consumer': self.consumer}
        with UPDATE(
            self.account,
            self.request.env,
            events,
        ):
            try:
                logical_op = SecurifyOperation.create(
                    phone_manager=self.account.phones,
                    phone_id=self.phone.id,
                    code='0000',
                    statbox=self.statbox,
                )
            except (SingleSecureOperationError, SecureNumberBoundAlready, NumberNotBound):
                raise ActionImpossibleError()

            try:
                next_logical_op, changes = logical_op.apply(need_authenticated_user=False, ignore_phones_confirmation=True)
            except OperationInapplicable:
                # это исключение по идее недостижимо, потому что не требуется пароль от пользователя или
                # подтверждение кода
                raise ActionImpossibleError()

            if next_logical_op is not None:
                # Next logical op не равен None, только когда исполняется
                # операция замены, но этот класс не испольузется для замены.
                raise NotImplementedError()
