# -*- coding: utf-8 -*-

from passport.backend.core import validators


class BaseSubmitForm(validators.Schema):
    display_language = validators.DisplayLanguage()
    uid = validators.Uid(if_missing=None)


class PhoneNumberSubmitForm(BaseSubmitForm):
    number = validators.String(not_empty=True, strip=True)
    country = validators.CountryCode(if_missing=None, not_empty=True)

    chained_validators = [
        validators.PhoneNumber(phone_number_key='number'),
    ]


class SecurifySudoForm(validators.Schema):
    uid = validators.Uid()
    phone_id = validators.PhoneId()


class PhoneIdSubmitForm(BaseSubmitForm):
    phone_id = validators.PhoneId()


class SecurifyPhoneSubmitForm(BaseSubmitForm):
    phone_id = validators.PhoneId()


class RemoveSecurePhoneSubmitForm(BaseSubmitForm):
    """Форма для ручки submit удаления защищённого телефона."""
    does_user_admit_secure_number = validators.StringBool()


class RemoveSimplePhoneForm(BaseSubmitForm):
    phone_id = validators.PhoneId()


class ReplaceSecurePhoneSubmitForm(BaseSubmitForm):
    number = validators.String(not_empty=True, strip=True, if_missing=None)
    country = validators.CountryCode(if_missing=None, not_empty=True)
    phone_id = validators.PhoneId(not_empty=False, if_missing=None)
    does_user_admit_secure_number = validators.StringBool()

    chained_validators = [
        validators.PhoneNumber(phone_number_key='number'),
        validators.RequireSome(
            some_fields=['number', 'phone_id'],
            rule_name='number_or_phone_id',
        ),
    ]


class OperationIdForm(validators.Schema):
    operation_id = validators.Int(not_empty=True, strip=True)
    uid = validators.Uid(if_missing=None)


class BindPhoneCommitForm(OperationIdForm):
    pass


class BindSecurePhoneSubmitForm(PhoneNumberSubmitForm):
    is_alias = validators.StringBool(if_empty=False, if_missing=False)


class BindSecurePhoneCommitForm(OperationIdForm):
    pass


class SecurePhoneSubmitForm(BaseSubmitForm):
    pass


class SendCodeForm(OperationIdForm):
    display_language = validators.DisplayLanguage()


class CheckCodeForm(OperationIdForm):
    code = validators.String(not_empty=True, strip=True)


class CheckPasswordForm(OperationIdForm):
    current_password = validators.String(not_empty=True, strip=True)


class AliasifySecurePhoneSubmitForm(BaseSubmitForm):
    pass


class DealiasifySecurePhoneSubmitForm(BaseSubmitForm):
    pass


class ProlongValidPhoneForm(BaseSubmitForm):
    phone_id = validators.PhoneId()


class SetDefaultPhoneForm(validators.Schema):
    phone_id = validators.PhoneId()
    uid = validators.Uid(if_missing=None)


class DisablePhonenumberAliasAsEmailForm(BaseSubmitForm):
    pass


class EnablePhonenumberAliasAsEmailForm(BaseSubmitForm):
    pass
