# -*- coding: utf-8 -*-

from ..helpers import dump_number


def get_phone_info(phone, original=None):
    number = original or phone.number
    output = {
        'number': dump_number(number),
        'id': phone.id,
    }

    if phone.operation:
        logical_op = phone.get_logical_operation(None)
        output['operation'] = get_operation_info(phone.operation, logical_op)

    return output


def get_operation_info(operation, logical_op):
    return {
        'id': operation.id,
        'security_identity': operation.security_identity,
        'in_quarantine': logical_op.in_quarantine,
    }
