# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.exceptions import BaseBundleError


class BasePushApiBundleError(BaseBundleError):
    """Базовая ошибка для всего пуш бандла"""


class PushApiBundleInvalidTokenError(BasePushApiBundleError):
    """Неверный токен"""
    error = 'push_api.token_invalid'


class PushApiBundleUnsupportedAppPlatformError(BasePushApiBundleError):
    """Неверная платформа"""
    error = 'push_api.app_platform_unsupported'


class PushApiBundleForbiddenServiceError(BasePushApiBundleError):
    """Неверный сервис"""
    error = 'push_api.service_forbidden'


class PushApiBundleInvalidCertError(BasePushApiBundleError):
    """Неверный сертификат"""
    error = 'push_api.cert_invalid'


class PushApiBundleNoSubscriptionsError(BasePushApiBundleError):
    """Нет подписок"""
    error = 'push_api.no_subscriptions'
