# -*- coding: utf-8 -*-
from passport.backend.core import validators


class PushApiRegisterForm(validators.Schema):
    app_id = validators.String(not_empty=True, strip=True)
    app_platform = validators.String(not_empty=True, strip=True)
    cert = validators.String(not_empty=True)


class PushApiSendAMPushForm(validators.Schema):
    check_subscriptions = validators.StringBool(if_missing=False)
    require_trusted_device = validators.StringBool(if_missing=False)
    uid = validators.Uid()
    push_service = validators.Regex(r'^[a-zA-Z0-9_]+$', not_empty=True)
    event_name = validators.Regex(r'^[a-zA-Z0-9_]+$', not_empty=True)
    title = validators.String()
    body = validators.String(if_missing=None)
    subtitle = validators.String(if_missing=None)
    webview_url = validators.SimpleUrlValidator(if_missing=None)
    require_web_auth = validators.StringBool(if_missing=True)
    context = validators.JSONValidator(if_missing=None)
    ttl = validators.Int(if_missing=None, not_empty=False, min=0)


class PushApiSubscribeForm(validators.Schema):
    app_id = validators.String(not_empty=True, strip=True)
    app_platform = validators.String(not_empty=True, strip=True)
    am_version = validators.Version(if_missing=None)
    app_version = validators.String(if_missing=None)
    client = validators.String(if_missing=None, not_empty=False, strip=True)
    deviceid = validators.String(not_empty=True, strip=True)
    device_token = validators.String(not_empty=True, strip=True)
    filter = validators.String(if_missing=None, not_empty=False, strip=True)


class PushApiUnsubscribeForm(validators.Schema):
    app_id = validators.String(not_empty=True, strip=True)
    deviceid = validators.String(not_empty=True, strip=True)
    uid = validators.Uid(not_empty=True)
