# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class RegistrationSmsSendPerIPLimitExceededError(BaseBundleError):
    """Превышен лимит на регистрацию с использованием sms для одного ip-адреса"""
    error = 'account.registration_limited'


class OauthClientAuthInvalidError(BaseBundleError):
    """Указан неверный client_id или client_secret"""
    error = 'oauth.client_auth_invalid'


class PkceInvalidError(BaseBundleError):
    """Указан неверный code_verifier"""
    error = 'pkce.invalid'


__all__ = (
    'RegistrationSmsSendPerIPLimitExceededError',
)
