# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.mailer.utils import (
    MailInfo,
    make_email_context,
)


AUTH_BY_KEY_LINK_MESSAGE_TEMPLATE = 'mail/auth_by_key_link_message_body.html'


def get_auth_by_key_link(key, tld):
    return settings.AUTH_BY_KEY_LINK_TEMPLATE_URL % dict(key=key, tld=tld)


def get_restore_link(tld):
    return settings.RESTORE_DEFAULT_URL_TEMPLATE % dict(tld=tld)


def get_auth_by_key_link_email_data(account, persistent_track):
    """
    Подготовить информацию для отправки сообщения с ссылкой
    Возвращает template_name, info, context.
    """

    # Письмо вне зависимости от настроек аккаунта отправляем на русском (часть
    # письма продублирована на английском, см. шаблон) - так хотят tools
    language = 'ru'
    tld = 'ru'

    translations = settings.translations.NOTIFICATIONS[language]
    template_name = AUTH_BY_KEY_LINK_MESSAGE_TEMPLATE

    info = MailInfo(
        subject=translations['digitreg.subject'],
        from_=translations['email_sender_display_name'],
        tld=tld,
    )
    auth_by_key_link = get_auth_by_key_link(persistent_track.track_key, tld)
    restore_link = get_restore_link(tld)
    context = make_email_context(
        language=language,
        account=account,
        context={
            'LOGIN': account.login,
            'COMPLETE_ACCOUNT_BY_KEY_LINK': auth_by_key_link,
            'RESTORATION_URL': restore_link,
        },
    )
    return template_name, info, context
