# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import (
    BaseBundleError,
    UnhandledBundleError,
)


class NoRestoreMethodsError(BaseBundleError):
    """Нет доступных способов восстановления"""
    error = 'account.no_restore_methods'


class RestoreMethodNotAllowedError(BaseBundleError):
    """Выбранный метод недоступен для восстановления аккаунте"""
    error = 'method.not_allowed'


class PhoneNotMatchedError(BaseBundleError):
    """Введенный номер телефона не является телефоном, подходящим для восстановления."""
    error = 'phone.not_matched'


class PhoneChangedError(BaseBundleError):
    """
    Номер телефона на аккаунте на текущий момент отличается от того,
    с которым был начат процесс.
    """
    error = 'phone.changed'


class PhoneCheckLimitExceededError(BaseBundleError):
    """Проверка телефона невозможна, превышен лимит."""
    error = 'phone.check_limit_exceeded'


class EmailNotMatchedError(BaseBundleError):
    """Введенный email-адрес не является адресом, подходящим для восстановления."""
    error = 'email.not_matched'


class EmailChangedError(BaseBundleError):
    """Введенный ранее email-адрес более не является адресом, подходящим для восстановления."""
    error = 'email.changed'


class EmailCheckLimitExceededError(BaseBundleError):
    """Проверка email-адреса невозможна, превышен лимит."""
    error = 'email.check_limit_exceeded'


class AnswerNotMatchedError(BaseBundleError):
    """Введенный КО неверен"""
    error = 'answer.not_matched'


class PinNotMatchedError(BaseBundleError):
    """Введенный PIN неверен"""
    error = 'pin.not_matched'


class PinCheckLimitExceededError(BaseBundleError):
    """Проверка пина невозможна, превышен лимит."""
    error = 'pin.check_limit_exceeded'


class ContactEmailFromSameAccountError(BaseBundleError):
    """Контактный email принадлежит аккаунту, к которому делается попытка восстановить доступ"""
    error = 'contact_email.from_same_account'


class SendmailFailedError(UnhandledBundleError):
    """При отправке письма чтото сломалось"""
    pass
