# -*- coding: utf-8 -*-

from passport.backend.api.common.phone import (
    CONFIRM_METHOD_BY_CALL,
    CONFIRM_METHOD_BY_FLASH_CALL,
    CONFIRM_METHOD_BY_SMS,
)
from passport.backend.core import validators


DEFAULT_STRING_UPPER_LIMIT = 1024


class LoginRestoreSubmitForm(validators.Schema):
    retpath = validators.RetPath(ignore_invalid=True, if_missing=None, not_empty=True, strip=True)

    gps_package_name = validators.GpsPackageName()


class LoginRestoreCheckPhoneForm(validators.Schema):
    phone_number = validators.String(not_empty=True, strip=True)
    country = validators.CountryCode(if_missing=None, strip=True)
    display_language = validators.DisplayLanguage()
    confirm_method = validators.OneOf(
        [CONFIRM_METHOD_BY_SMS, CONFIRM_METHOD_BY_CALL, CONFIRM_METHOD_BY_FLASH_CALL],
        if_missing=CONFIRM_METHOD_BY_SMS,
        not_empty=True,
    )
    code_format = validators.OneOf(['by_3', 'by_3_dash'], if_missing=None, not_empty=True)

    chained_validators = [
        validators.PhoneNumber(),
    ]


class LoginRestoreConfirmPhoneForm(validators.Schema):
    code = validators.String(not_empty=True, strip=True)


class LoginRestoreCheckNamesForm(validators.Schema):
    firstname = validators.FirstName(not_empty=True)
    lastname = validators.LastName(not_empty=True)


class LoginRestoreCheckNamesSimpleForm(LoginRestoreCheckNamesForm):
    allow_disabled = validators.StringBool(not_empty=True, if_missing=True)
    allow_social = validators.StringBool(not_empty=True, if_missing=False)
    allow_neophonish = validators.StringBool(not_empty=True, if_missing=False)
