# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.mixins import TrackRestricter
from passport.backend.api.views.bundle.phone.exceptions import SendingLimitExceededError
from passport.backend.core.counters.sms_per_phone import get_per_phone_buckets


class LoginRestoreRestricter(TrackRestricter):
    def __init__(self, *args):
        super(LoginRestoreRestricter, self).__init__(*args)
        self.restrict_ip()
        self.restrict_rate()
        self.restrict_reconfirmation()

    def check(self):
        super(LoginRestoreRestricter, self).check()
        counter = get_per_phone_buckets()

        if counter.hit_limit(self._phone_number.digital):
            self._statbox.stash(error='sms_limit.exceeded')
            raise SendingLimitExceededError()

    def update(self):
        super(LoginRestoreRestricter, self).update()
        get_per_phone_buckets().incr(self._phone_number.digital)
