# -*- coding: utf-8 -*-

# Версия нужна для учета изменений факторов, а также для информирования пользователей при обновлении
MULTISTEP_FORM_VERSION = 'multistep.4.3'

RESTORE_MESSAGE_REQUEST_SOURCE_FOR_LEARNING = 'learning'

RESTORE_MESSAGE_REQUEST_SOURCE_FOR_POSITIVE_DECISION_RETRY = 'retry'

DECISION_SOURCE_BASIC_FORMULA = 'basic_formula'

DECISION_SOURCE_TENSORNET = 'tensornet'

DECISION_SOURCE_UNCONDITIONAL = 'unconditional'

from .step_forms import (
    STEP_1_PERSONAL_DATA_SCHEMA,
    STEP_1_PERSONAL_DATA_STRICT_SCHEMA,
    STEP_2_RECOVERY_TOOLS_SCHEMA,
    STEP_2_RECOVERY_TOOLS_STRICT_SCHEMA,
    STEP_3_REGISTRATION_DATA_SCHEMA,
    STEP_3_REGISTRATION_DATA_STRICT_SCHEMA,
    STEP_4_USED_SERVICES_SCHEMA,
    STEP_4_USED_SERVICES_STRICT_SCHEMA,
    STEP_5_SERVICES_DATA_SCHEMA,
    STEP_5_SERVICES_DATA_STRICT_SCHEMA,
    STEP_6_FINAL_INFO_SCHEMA,
    STEP_6_FINAL_INFO_STRICT_SCHEMA,
)


STEP_1_PERSONAL_DATA = 'personal_data'
STEP_2_RECOVERY_TOOLS = 'recovery_tools'
STEP_3_REGISTRATION_DATA = 'registration_data'
STEP_4_USED_SERVICES = 'used_services'
STEP_5_SERVICES_DATA = 'services_data'
STEP_6_FINAL_INFO = 'final_info'

STEP_FINISHED = 'finished'


DATA_STEPS = (
    STEP_1_PERSONAL_DATA,
    STEP_2_RECOVERY_TOOLS,
    STEP_3_REGISTRATION_DATA,
    STEP_4_USED_SERVICES,
    STEP_5_SERVICES_DATA,
    STEP_6_FINAL_INFO,
)

STEP_TO_INDEX = dict([(step, i) for (i, step) in enumerate(DATA_STEPS)])


STEP_TO_SCHEMA_MAPPING = dict(zip(
    DATA_STEPS,
    (
        STEP_1_PERSONAL_DATA_SCHEMA,
        STEP_2_RECOVERY_TOOLS_SCHEMA,
        STEP_3_REGISTRATION_DATA_SCHEMA,
        STEP_4_USED_SERVICES_SCHEMA,
        STEP_5_SERVICES_DATA_SCHEMA,
        STEP_6_FINAL_INFO_SCHEMA,
    ),
))


STEP_TO_STRICT_SCHEMA_MAPPING = dict(zip(
    DATA_STEPS,
    (
        STEP_1_PERSONAL_DATA_STRICT_SCHEMA,
        STEP_2_RECOVERY_TOOLS_STRICT_SCHEMA,
        STEP_3_REGISTRATION_DATA_STRICT_SCHEMA,
        STEP_4_USED_SERVICES_STRICT_SCHEMA,
        STEP_5_SERVICES_DATA_STRICT_SCHEMA,
        STEP_6_FINAL_INFO_STRICT_SCHEMA,
    ),
))


STEP_TO_FACTORS_MAPPING = dict(zip(
    DATA_STEPS,
    (
        ['multiple_names', 'birthday', 'passwords'],
        ['phone_numbers', 'confirmed_emails', 'question_answer'],
        ['registration_date', 'reg_country_city', 'user_env_auths', 'aggregated_factors'],
        ['social_accounts', 'services'],
        [
            'delivery_addresses',
            'email_folders',
            'outbound_emails',
            'email_collectors',
            'email_blackwhite',
            'restore_attempts',
        ],
        [],
    ),
))


def get_next_step(step):
    if step == STEP_6_FINAL_INFO:
        return STEP_FINISHED
    step_index = STEP_TO_INDEX.get(step)
    if step_index is not None:
        return DATA_STEPS[step_index + 1]


def get_step_fields(step):
    json_schema = STEP_TO_STRICT_SCHEMA_MAPPING.get(step)
    return json_schema.schema.get('properties', {}).keys() if json_schema is not None else []
