# -*- coding: utf-8 -*-
from passport.backend.core import validators
from passport.backend.core.conf import settings


DEFAULT_RESTORE_REQUEST_SOURCE = 'restore'


class RestoreSemiAutoSubmitForm(validators.Schema):

    login = validators.LooseEmailValidator()

    # Идентификатор источника, отправившего пользователя на анкету
    request_source = validators.String(not_empty=True, if_missing=DEFAULT_RESTORE_REQUEST_SOURCE)

    app_id = validators.String(if_missing=None)

    # Что пользователь успел навводить пользуясь автоматическим восстановлением
    # Пока передаем единственные значения (например, последние введенные), нужно будет согласовать
    email = validators.UnicodeString(if_missing=None)
    question_id = validators.HintQuestionId(if_missing=None)
    question = validators.HintQuestion(if_missing=None)
    answer = validators.HintAnswer(if_missing=None)
    phone_number = validators.String(if_missing=None, strip=True)

    chained_validators = [
        validators.PhoneNumber(phone_number_key='phone_number'),
        validators.RequireSet(
            allowed_sets=[
                ['question_id', 'answer'],
                ['question', 'answer'],
            ],
            allow_empty=True,
        ),
    ]


class RestoreSemiAutoSubmitWithCaptchaForm(validators.Schema):

    login = validators.LooseEmailValidator()

    # Идентификатор источника, отправившего пользователя на анкету
    request_source = validators.String(not_empty=True, if_missing=DEFAULT_RESTORE_REQUEST_SOURCE)

    # Признак того, что анкета используется для пропуска пользователя в саппорт без проверок
    is_unconditional_pass = validators.StringBool(if_missing=False)


class RestoreSemiAutoValidateForm(validators.Schema):

    contact_email = validators.SimpleEmailValidator()


class RestoreSemiAutoCommitShortForm(validators.Schema):

    firstname = validators.FirstName(not_empty=True)
    lastname = validators.LastName(not_empty=True)
    birthday = validators.Birthday(not_empty=True, year_offset=200)
    eula_accepted = validators.StringBool(not_empty=True)
    registration_date = validators.LooseDateValidator(
        not_empty=True,
        earliest_year=settings.YANDEX_FOUNDATION_YEAR,
        max_days_in_future=2,
    )
    registration_country = validators.UnicodeString(not_empty=True)
    registration_city = validators.UnicodeString(if_missing=None, not_empty=True)
    # Так как поля с ID могут быть не заполнены в случае ошибок при использовании
    # suggest'а, делаем их необязательными для ввода.
    registration_country_id = validators.Int(if_missing=None, not_empty=False)
    registration_city_id = validators.Int(if_missing=None, not_empty=False)
