# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class BaseChangeSocialBundleError(BaseBundleError):
    """ Базовая ошибка страницы социальных профилей """


class NotUsersProfileError(BaseChangeSocialBundleError):
    """
    Профиль не принадлежит пользователю
    """
    error = 'social_profile.invalid'


class SingleAuthMethodError(BaseChangeSocialBundleError):
    """
    Последнее средство авторизации нельзя удалить
    """
    error = 'social_profile.single_auth_method'


class ProviderNotAllowAuthError(BaseChangeSocialBundleError):
    """
    Нельзя входить через соц. профиль от данного провайдера
    """
    error = 'social_profile.provider_not_allow_auth'
