# -*- coding: utf-8 -*-
from passport.backend.core import validators
from passport.backend.core.conf import settings


class SubscriptionForm(validators.Schema):
    profile_id = validators.Int(not_empty=True, strip=True)
    sid = validators.OneOf([], not_empty=True, strip=True)

    def __init__(self):
        super(SubscriptionForm, self).__init__()

        # Если передать ALLOWED_SIDS в валидатор sid при создании, то неизвестно, что
        # туда проставится на самом деле. Это зависит от порядка импортов и инициализации конфигов,
        # что плохо, да и тестировать тяжело.
        ALLOWED_SIDS = [str(social_subscription['sid']) for social_subscription in settings.SOCIAL_DEFAULT_SUBSCRIPTION]
        self.fields['sid'].list = ALLOWED_SIDS


class DeleteForm(validators.Schema):
    profile_id = validators.Int(not_empty=True, strip=True)


class DeleteWithPasswordForm(DeleteForm):
    current_password = validators.String(not_empty=True, if_missing=None)


class SetAuthForm(validators.Schema):
    profile_id = validators.Int(not_empty=True, strip=True, if_missing=None)
    set_auth = validators.Int(not_empty=True, strip=True, min=0, max=1)


class SetAuthWithPasswordForm(SetAuthForm):
    current_password = validators.String(not_empty=True, if_missing=None)


class SocialThumbnailForm(validators.Schema):

    task_id = validators.HexString(not_empty=True, strip=True)

    avatar_size_x = validators.Int(min=0, not_empty=True)
    avatar_size_y = validators.Int(min=0, not_empty=True)


class SocialFillPersonalDataSubmitForm(validators.Schema):
    task_id = validators.HexString(not_empty=True, strip=True)
