# -*- coding: utf-8 -*-

from passport.backend.core import validators


class SuggestLoginForm(validators.Schema):
    """
    Форма для генерации возможных логинов пользователя.

    Невалидность логина не мешает нам предложить валидные варианты,
    поэтому не валидируем его. И еще в нем может оказаться емэйл.
    """
    login = validators.String(if_missing=None, not_empty=True, strip=True, max=100)
    first_name = validators.FirstName(if_missing=None, not_empty=True)
    last_name = validators.LastName(if_missing=None, not_empty=True)
    # Пытаемся угадать язык или используем дефолтный русский
    language = validators.DetectedLanguage(if_missing=None)

    chained_validators = [
        validators.RequireSome(
            [
                'first_name',
                'last_name',
                'login',
            ],
            min_=1,
            max_=3,
        ),
    ]
