# -*- coding: utf-8 -*-
from passport.backend.core import validators


class UserInfoForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    unixtime = validators.Unixtime()


class RequestExtractForm(validators.Schema):
    uid = validators.Uid(if_missing=None)


class StartExtractForm(validators.Schema):
    uid = validators.Uid(not_empty=True)


class FinishExtractForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
    archive_s3_key = validators.String(not_empty=True)
    archive_password = validators.String(if_missing=None, if_empty=None)


class GetExtractResultForm(validators.Schema):
    uid = validators.Uid(if_missing=None)


class DeleteExtractResultForm(validators.Schema):
    uid = validators.Uid(not_empty=True)
