# -*- coding: utf-8 -*-
from passport.backend.api.common.processes import ALL_PROCESSES
from passport.backend.core import validators
from passport.backend.core.conf import settings
from passport.backend.core.tracks.model import TRACK_TYPES


class InitializeTrackForm(validators.Schema):
    """Форма для создания трека с уже заполненным уидом"""
    uid = validators.Uid(if_missing=None)

    track_type = validators.OneOf(
        # FIXME: PASSP-11574 Как только последние потребители account/social
        # смирятся с неизбежностью - оставить только TRACK_TYPES.
        list(TRACK_TYPES.keys()) + list(settings.DELETED_TRACK_TYPES),
        if_missing='authorize',
        not_empty=True,
    )

    process_name = validators.OneOf(ALL_PROCESSES, if_missing=None)


class InitializeInfectedTrackForm(validators.Schema):
    """Форма для создания трека для процесса инфицирования"""
    retpath = validators.RetPath(if_missing=None, ignore_invalid=False, not_empty=True)
