# -*- coding: utf-8 -*-
from passport.backend.api.views.bundle.exceptions import BaseBundleError


class WebauthnRegistrationRejectedError(BaseBundleError):
    """Не удалось добавить креденшл"""
    error = 'webauthn.registration_rejected'


class WebauthnCredentialExistsError(BaseBundleError):
    """Креденшл уже принадлежит текущему пользователю"""
    error = 'webauthn.credential_exists'


class WebauthnCredentialOccupiedError(BaseBundleError):
    """Креденшл уже принадлежит другому пользователю"""
    error = 'webauthn.credential_occupied'


class WebauthnCredentialNotFoundError(BaseBundleError):
    """Креденшл с указанным external_id не найден"""
    error = 'webauthn.credential_not_found'


class WebauthnVerificationRejectedError(BaseBundleError):
    """Не удалось подтвердить владение креденшлом"""
    error = 'webauthn.verification_rejected'


class WebauthnCredentialLimitReachedError(BaseBundleError):
    """Слишком много кредов, нельзя добавить ещё один"""
    error = 'webauthn.credential_limit_reached'
