# -*- coding: utf-8 -*-
from passport.backend.core import validators


class WebauthnAddCredentialCommitForm(validators.Schema):
    origin = validators.String(not_empty=True)
    client_data = validators.Base64String(decode=False)
    attestation_object = validators.Base64String(decode=False)
    device_name = validators.String(if_missing=None, strip=True)


class WebauthnRemoveCredentialForm(validators.Schema):
    credential_external_id = validators.String(not_empty=True)


class WebauthnVerifySubmitForm(validators.Schema):
    uid = validators.Uid(if_missing=None)
    credential_external_id = validators.String(not_empty=True)


class WebauthnVerifyCommitForm(WebauthnVerifySubmitForm):
    origin = validators.String(not_empty=True)
    client_data = validators.Base64String(decode=False)
    auth_data = validators.Base64String(decode=False)
    signature = validators.HexString()
