# -*- coding: utf-8 -*-
from passport.backend.api.forms.base import DeviceInfoForm
from passport.backend.core import validators


YAKEY_BACKUP_MAX_SIZE = 200 * 1024  # 200 Kb в байтах


class BaseNumberedForm(validators.Schema):
    number = validators.String(not_empty=True, strip=True)
    country = validators.CountryCode(if_missing=None, not_empty=True)

    chained_validators = [
        validators.PhoneNumber(phone_number_key='number'),
    ]


class BaseBackupForm(DeviceInfoForm):
    number = validators.String(not_empty=True, strip=True)
    country = validators.CountryCode(if_missing=None, not_empty=True)

    chained_validators = [
        validators.PhoneNumber(phone_number_key='number'),
    ]


class UploadCommitForm(BaseBackupForm):
    force_update = validators.StringBool(if_missing=False, not_empty=True)
    backup = validators.ASCIIString(max=YAKEY_BACKUP_MAX_SIZE)


class ConfirmSubmitForm(BaseNumberedForm):
    """
    Если переданный язык отстутвует в разрешенных,
    то пытаемся угадать или используем дефолтный.
    """
    display_language = validators.DetectedLanguage()
