# -*- coding: utf-8 -*-
from functools import wraps

from flask import request
from passport.backend.core.grants import get_grants
from passport.backend.utils.common import merge_dicts


def grants(required_grants, optional_grants=None, **top_kwargs):
    def grants_wrapper(f):
        @wraps(f)
        def _wrapper(*args, **kwargs):
            get_grants().check_access(
                request.env.consumer_ip,
                [args[0].get('consumer')],
                required_grants,
                optional_grants=optional_grants,
                grants_args=args,
                grants_kwargs=merge_dicts(top_kwargs, kwargs),
                service_ticket=request.env.service_ticket,
            )
            return f(*args, **kwargs)
        return _wrapper
    return grants_wrapper
