# -*- coding: utf-8 -*-
import logging

from flask import current_app
from passport.backend.api import forms
from passport.backend.api.common.decorators import validate
from passport.backend.api.common.format_response import ok_response
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers.statbox import to_statbox

from .grants import grants


log = logging.getLogger('passport.api.views')


@validate(forms.TrackedConsumerForm(filter_extra_fields=False))
@grants(['statbox'])
def statbox_create(args):
    args.update(_is_external_event=True)
    to_statbox(args)
    return ok_response()


def profile_dump(*args):
    if settings.PROFILE_ENABLED:
        current_app.profile.dump_stats(settings.PROFILE_STATS_PATH)
    return ok_response()


__all__ = (
    'statbox_create',
    'profile_dump',
)
