PY23_LIBRARY(passport_api)

OWNER(
    g:passport_python
)

NEED_REVIEW()

IF (NOT OS_WINDOWS)

PEERDIR(
    contrib/python/defusedxml
    contrib/python/Flask
    contrib/python/Jinja2
    contrib/python/cryptography
    contrib/python/python-ldap
    contrib/python/mysqlclient
    contrib/python/psutil
    contrib/python/six
    contrib/python/webauthn

    passport/backend/takeout/logbroker_client/extract_task_message
    passport/backend/api/settings
    passport/backend/api/templates
    passport/backend/contrib/elementflow
    passport/backend/core
    passport/backend/core/am_pushes
    passport/backend/core/builders/messenger_api
    passport/backend/core/builders/shakur
    passport/backend/core/builders/staff
    passport/backend/core/builders/trust_api
    passport/backend/core/logbroker
    passport/backend/core/protobuf/challenge_pushes
    passport/backend/core/protobuf/logbroker_test
    passport/backend/core/utils/ldap
    passport/backend/utils

    passport/backend/library/configurator
    passport/backend/library/tensornet

    statbox/libstatbox/python
)

IF (PYTHON2)
    PEERDIR(
        contrib/python/python-saml
    )
ELSE()
    PEERDIR(
        contrib/python/python3-saml
    )
ENDIF()

PY_SRCS(
    app.py
    common/account.py
    common/account_manager.py
    common/authorization.py
    common/auth_challenge.py
    common/common.py
    common/decorators.py
    common/errors.py
    common/format_response.py
    common/grants.py
    common/historydb_api.py
    common/ip.py
    common/logbroker.py
    common/login.py
    common/logs.py
    common/mail.py
    common/mail_api.py
    common/oauth.py
    common/octopus.py
    common/pdd.py
    common/phone.py
    common/phone_karma/phone_karma.py
    common/phone_karma/__init__.py
    common/phone_number.py
    common/phonish.py
    common/processes.py
    common/profile/estimate.py
    common/profile/features.py
    common/profile/profile.py
    common/profile/utils.py
    common/profile/__init__.py
    common/restore.py
    common/social_api.py
    common/suggest.py
    common/webauthn.py
    common/yasms.py
    common/__init__.py
    configs/__init__.py
    email_validator/base.py
    email_validator/exceptions.py
    email_validator/forms.py
    email_validator/mixins.py
    email_validator/utils.py
    email_validator/views.py
    email_validator/__init__.py
    env/env.py
    env/__init__.py
    exceptions.py
    forms/account.py
    forms/base.py
    forms/captcha.py
    forms/oauth.py
    forms/password.py
    forms/phone.py
    forms/phone_confirmation.py
    forms/register.py
    forms/session.py
    forms/subscription.py
    forms/suggest.py
    forms/track.py
    forms/validation.py
    forms/__init__.py
    legacy/common.py
    legacy/forms.py
    legacy/validators.py
    legacy/views.py
    legacy/__init__.py
    mobile_proxy/controllers/base.py
    mobile_proxy/controllers/blackbox_controllers.py
    mobile_proxy/controllers/errors.py
    mobile_proxy/controllers/oauth_controllers.py
    mobile_proxy/controllers/passport_controllers.py
    mobile_proxy/controllers/__init__.py
    mobile_proxy/__init__.py
    templatefilters.py
    templatetags.py
    validators.py
    views/account.py
    views/bundle/account/account_options.py
    views/bundle/account/aliases.py
    views/bundle/account/app_passwords/forms.py
    views/bundle/account/app_passwords/manage.py
    views/bundle/account/app_passwords/switch.py
    views/bundle/account/app_passwords/__init__.py
    views/bundle/account/avatars/base.py
    views/bundle/account/avatars/controllers.py
    views/bundle/account/avatars/forms.py
    views/bundle/account/avatars/__init__.py
    views/bundle/account/check_exists.py
    views/bundle/account/delete.py
    views/bundle/account/events/controllers.py
    views/bundle/account/events/forms.py
    views/bundle/account/events/__init__.py
    views/bundle/account/exceptions.py
    views/bundle/account/external_data/base.py
    views/bundle/account/external_data/controllers/afisha.py
    views/bundle/account/external_data/controllers/collections.py
    views/bundle/account/external_data/controllers/disk.py
    views/bundle/account/external_data/controllers/maps.py
    views/bundle/account/external_data/controllers/market.py
    views/bundle/account/external_data/controllers/music.py
    views/bundle/account/external_data/controllers/video.py
    views/bundle/account/external_data/controllers/__init__.py
    views/bundle/account/external_data/exceptions.py
    views/bundle/account/external_data/forms.py
    views/bundle/account/external_data/__init__.py
    views/bundle/account/federal_change.py
    views/bundle/account/flush_pdd.py
    views/bundle/account/forms.py
    views/bundle/account/get_account_info.py
    views/bundle/account/history/controllers.py
    views/bundle/account/history/exceptions.py
    views/bundle/account/history/forms.py
    views/bundle/account/history/__init__.py
    views/bundle/account/lastauth/controllers.py
    views/bundle/account/lastauth/forms.py
    views/bundle/account/lastauth/__init__.py
    views/bundle/account/logout/controllers.py
    views/bundle/account/logout/forms.py
    views/bundle/account/logout/__init__.py
    views/bundle/account/migrate_mailish.py
    views/bundle/account/notifications/__init__.py
    views/bundle/account/notifications/controllers.py
    views/bundle/account/notifications/forms.py
    views/bundle/account/options/base_handlers.py
    views/bundle/account/options/config.py
    views/bundle/account/options/controllers.py
    views/bundle/account/options/forms.py
    views/bundle/account/options/grants.py
    views/bundle/account/options/handlers.py
    views/bundle/account/options/options.py
    views/bundle/account/options/utils.py
    views/bundle/account/options/__init__.py
    views/bundle/account/password_options.py
    views/bundle/account/phonish/base.py
    views/bundle/account/phonish/controllers.py
    views/bundle/account/phonish/forms.py
    views/bundle/account/phonish/__init__.py
    views/bundle/account/questions/controllers.py
    views/bundle/account/questions/forms.py
    views/bundle/account/questions/history.py
    views/bundle/account/questions/__init__.py
    views/bundle/account/reset.py
    views/bundle/account/secrets/base.py
    views/bundle/account/secrets/browser_key.py
    views/bundle/account/secrets/exceptions.py
    views/bundle/account/secrets/forms.py
    views/bundle/account/secrets/passman_recovery_key.py
    views/bundle/account/secrets/__init__.py
    views/bundle/account/set_password.py
    views/bundle/account/subscriptions/forms.py
    views/bundle/account/subscriptions/subscribe.py
    views/bundle/account/subscriptions/unsubscribe.py
    views/bundle/account/subscriptions/__init__.py
    views/bundle/account/update_personal_info.py
    views/bundle/account/userapprove/controllers.py
    views/bundle/account/userapprove/forms.py
    views/bundle/account/userapprove/__init__.py
    views/bundle/account/__init__.py
    views/bundle/auth/base.py
    views/bundle/auth/drive/__init__.py
    views/bundle/auth/drive/controllers.py
    views/bundle/auth/drive/exceptions.py
    views/bundle/auth/drive/forms.py
    views/bundle/auth/exceptions.py
    views/bundle/auth/forms.py
    views/bundle/auth/forwarding/controllers.py
    views/bundle/auth/forwarding/forms.py
    views/bundle/auth/forwarding/helpers.py
    views/bundle/auth/forwarding/__init__.py
    views/bundle/auth/key_link/forms.py
    views/bundle/auth/key_link/submit.py
    views/bundle/auth/key_link/__init__.py
    views/bundle/auth/multi.py
    views/bundle/auth/oauth/forms.py
    views/bundle/auth/oauth/issue_code.py
    views/bundle/auth/oauth/recreate_kolonkish_token.py
    views/bundle/auth/oauth/recreate_yambot_token.py
    views/bundle/auth/oauth/submit.py
    views/bundle/auth/oauth/__init__.py
    views/bundle/auth/sso/controllers/__init__.py
    views/bundle/auth/sso/controllers/auth.py
    views/bundle/auth/sso/controllers/complete_federal.py
    views/bundle/auth/sso/controllers/metadata.py
    views/bundle/auth/sso/exceptions.py
    views/bundle/auth/sso/forms.py
    views/bundle/auth/sso/__init__.py
    views/bundle/auth/otp/commit.py
    views/bundle/auth/otp/forms.py
    views/bundle/auth/otp/prepare_with_cred.py
    views/bundle/auth/otp/submit.py
    views/bundle/auth/otp/__init__.py
    views/bundle/auth/password/base.py
    views/bundle/auth/password/change_password.py
    views/bundle/auth/password/complete_autoregistered.py
    views/bundle/auth/password/complete_pdd.py
    views/bundle/auth/password/confirm.py
    views/bundle/auth/password/exceptions.py
    views/bundle/auth/password/forms.py
    views/bundle/auth/password/get_state.py
    views/bundle/auth/password/multi_step/auth.py
    views/bundle/auth/password/multi_step/base.py
    views/bundle/auth/password/multi_step/forms.py
    views/bundle/auth/password/multi_step/start.py
    views/bundle/auth/password/multi_step/__init__.py
    views/bundle/auth/password/rfc_otp.py
    views/bundle/auth/password/start.py
    views/bundle/auth/password/submit.py
    views/bundle/auth/password/__init__.py
    views/bundle/auth/social/base.py
    views/bundle/auth/social/controllers.py
    views/bundle/auth/social/exceptions.py
    views/bundle/auth/social/forms.py
    views/bundle/auth/social/states.py
    views/bundle/auth/social/__init__.py
    views/bundle/auth/suggest/controllers.py
    views/bundle/auth/suggest/exceptions.py
    views/bundle/auth/suggest/forms.py
    views/bundle/auth/suggest/__init__.py
    views/bundle/auth/suggest_by_phone/controllers.py
    views/bundle/auth/suggest_by_phone/forms.py
    views/bundle/auth/suggest_by_phone/__init__.py
    views/bundle/auth/third_step/controllers.py
    views/bundle/auth/third_step/forms.py
    views/bundle/auth/third_step/__init__.py
    views/bundle/auth/token/forms.py
    views/bundle/auth/token/submit.py
    views/bundle/auth/token/__init__.py
    views/bundle/auth/__init__.py
    views/bundle/autofill/controllers.py
    views/bundle/autofill/exceptions.py
    views/bundle/autofill/forms.py
    views/bundle/autofill/__init__.py
    views/bundle/base.py
    views/bundle/billing/controllers.py
    views/bundle/billing/forms.py
    views/bundle/billing/__init__.py
    views/bundle/billing/trust_3ds/controllers.py
    views/bundle/billing/trust_3ds/exceptions.py
    views/bundle/billing/trust_3ds/forms.py
    views/bundle/billing/trust_3ds/__init__.py
    views/bundle/captcha/controllers.py
    views/bundle/captcha/__init__.py
    views/bundle/challenge/__init__.py
    views/bundle/challenge/challenges.py
    views/bundle/challenge/controllers.py
    views/bundle/challenge/exceptions.py
    views/bundle/challenge/forms.py
    views/bundle/change_avatar/base.py
    views/bundle/change_avatar/controllers.py
    views/bundle/change_avatar/exceptions.py
    views/bundle/change_avatar/forms.py
    views/bundle/change_avatar/__init__.py
    views/bundle/change_password/controllers.py
    views/bundle/change_password/forms.py
    views/bundle/change_password/kinopoisk.py
    views/bundle/change_password/scholar.py
    views/bundle/change_password/__init__.py
    views/bundle/complete/base.py
    views/bundle/complete/controllers.py
    views/bundle/complete/forms.py
    views/bundle/complete/__init__.py
    views/bundle/constants.py
    views/bundle/cookies/controllers.py
    views/bundle/cookies/exceptions.py
    views/bundle/cookies/forms.py
    views/bundle/cookies/__init__.py
    views/bundle/device_public_key/__init__.py
    views/bundle/device_public_key/controllers.py
    views/bundle/device_public_key/exceptions.py
    views/bundle/device_public_key/forms.py
    views/bundle/email/base.py
    views/bundle/email/controllers.py
    views/bundle/email/exceptions.py
    views/bundle/email/forms.py
    views/bundle/email/old_controllers.py
    views/bundle/email/__init__.py
    views/bundle/exceptions.py
    views/bundle/family/__init__.py
    views/bundle/family/accept_invite.py
    views/bundle/family/add_member.py
    views/bundle/family/change_child_avatar.py
    views/bundle/family/change_kiddish.py
    views/bundle/family/create.py
    views/bundle/family/create_child.py
    views/bundle/family/create_kiddish.py
    views/bundle/family/delete.py
    views/bundle/family/delete_child.py
    views/bundle/family/delete_kiddish.py
    views/bundle/family/forms.py
    views/bundle/family/invite_info.py
    views/bundle/family/invites_info.py
    views/bundle/family/issue_invite.py
    views/bundle/family/leave.py
    views/bundle/family/revoke_invite.py
    views/bundle/family/remove_member.py
    views/bundle/headers.py
    views/bundle/idm/__init__.py
    views/bundle/idm/base.py
    views/bundle/idm/controllers.py
    views/bundle/idm/exceptions.py
    views/bundle/idm/forms.py
    views/bundle/internal/controllers.py
    views/bundle/internal/exceptions.py
    views/bundle/internal/forms.py
    views/bundle/internal/totp.py
    views/bundle/internal/track.py
    views/bundle/internal/__init__.py
    views/bundle/mail_subscriptions/__init__.py
    views/bundle/mail_subscriptions/controllers.py
    views/bundle/mail_subscriptions/forms.py
    views/bundle/mda2/container.py
    views/bundle/mda2/controllers.py
    views/bundle/mda2/exceptions.py
    views/bundle/mda2/forms.py
    views/bundle/mda2/__init__.py
    views/bundle/mdapi/base.py
    views/bundle/mdapi/domain.py
    views/bundle/mdapi/exceptions.py
    views/bundle/mdapi/forms.py
    views/bundle/mdapi/__init__.py
    views/bundle/mixins/account.py
    views/bundle/mixins/avatar.py
    views/bundle/mixins/common.py
    views/bundle/mixins/challenge.py
    views/bundle/mixins/child.py
    views/bundle/mixins/family.py
    views/bundle/mixins/federal.py
    views/bundle/mixins/kiddish.py
    views/bundle/mixins/kolmogor.py
    views/bundle/mixins/magic_link.py
    views/bundle/mixins/mail.py
    views/bundle/mixins/messenger.py
    views/bundle/mixins/neophonish.py
    views/bundle/mixins/oauth.py
    views/bundle/mixins/password.py
    views/bundle/mixins/phone.py
    views/bundle/mixins/push.py
    views/bundle/mixins/scholar.py
    views/bundle/mixins/session.py
    views/bundle/mixins/__init__.py
    views/bundle/mobile/controllers/auth.py
    views/bundle/mobile/controllers/base.py
    views/bundle/mobile/controllers/magic_link.py
    views/bundle/mobile/controllers/register.py
    views/bundle/mobile/controllers/register_lite.py
    views/bundle/mobile/controllers/register_neophonish.py
    views/bundle/mobile/controllers/register_phonish.py
    views/bundle/mobile/controllers/start.py
    views/bundle/mobile/controllers/validate.py
    views/bundle/mobile/controllers/__init__.py
    views/bundle/mobile/exceptions.py
    views/bundle/mobile/forms.py
    views/bundle/mobile/__init__.py
    views/bundle/oauth/controllers.py
    views/bundle/oauth/forms.py
    views/bundle/oauth/__init__.py
    views/bundle/otp/base.py
    views/bundle/otp/disable/base.py
    views/bundle/otp/disable/check_otp.py
    views/bundle/otp/disable/commit.py
    views/bundle/otp/disable/submit.py
    views/bundle/otp/disable/__init__.py
    views/bundle/otp/enable/base.py
    views/bundle/otp/enable/check_otp.py
    views/bundle/otp/enable/commit.py
    views/bundle/otp/enable/forms.py
    views/bundle/otp/enable/get_secret.py
    views/bundle/otp/enable/get_state.py
    views/bundle/otp/enable/set_pin.py
    views/bundle/otp/enable/save_device.py
    views/bundle/otp/enable/submit.py
    views/bundle/otp/enable/__init__.py
    views/bundle/otp/exceptions.py
    views/bundle/otp/forms.py
    views/bundle/otp/migrate/base.py
    views/bundle/otp/migrate/check_otp.py
    views/bundle/otp/migrate/commit.py
    views/bundle/otp/migrate/forms.py
    views/bundle/otp/migrate/get_secret.py
    views/bundle/otp/migrate/submit.py
    views/bundle/otp/migrate/__init__.py
    views/bundle/otp/not_me.py
    views/bundle/otp/otpauth.py
    views/bundle/otp/rfc/controllers.py
    views/bundle/otp/rfc/forms.py
    views/bundle/otp/rfc/helpers.py
    views/bundle/otp/rfc/__init__.py
    views/bundle/otp/set_check_time.py
    views/bundle/otp/short_info.py
    views/bundle/otp/__init__.py
    views/bundle/phone/base.py
    views/bundle/phone/controllers.py
    views/bundle/phone/controllers_v2.py
    views/bundle/phone/exceptions.py
    views/bundle/phone/forms.py
    views/bundle/phone/forms_v2.py
    views/bundle/phone/helpers.py
    views/bundle/phone/manage/base.py
    views/bundle/phone/manage/controllers/commit.py
    views/bundle/phone/manage/controllers/other.py
    views/bundle/phone/manage/controllers/submit.py
    views/bundle/phone/manage/controllers/sudo.py
    views/bundle/phone/manage/controllers/__init__.py
    views/bundle/phone/manage/forms.py
    views/bundle/phone/manage/helpers.py
    views/bundle/phone/manage/__init__.py
    views/bundle/phone/__init__.py
    views/bundle/push/controllers.py
    views/bundle/push/exceptions.py
    views/bundle/push/forms.py
    views/bundle/push/__init__.py
    views/bundle/push/push_2fa/controllers.py
    views/bundle/push/push_2fa/exceptions.py
    views/bundle/push/push_2fa/__init__.py
    views/bundle/register/controllers.py
    views/bundle/register/exceptions.py
    views/bundle/register/forms.py
    views/bundle/register/get_or_create.py
    views/bundle/register/helpers.py
    views/bundle/register/__init__.py
    views/bundle/restore/base.py
    views/bundle/restore/controllers.py
    views/bundle/restore/exceptions.py
    views/bundle/restore/factors.py
    views/bundle/restore/forms.py
    views/bundle/restore/helpers.py
    views/bundle/restore/login/controllers.py
    views/bundle/restore/login/forms.py
    views/bundle/restore/login/helpers.py
    views/bundle/restore/login/__init__.py
    views/bundle/restore/method_controllers.py
    views/bundle/restore/other_controllers.py
    views/bundle/restore/semi_auto/base.py
    views/bundle/restore/semi_auto/controllers.py
    views/bundle/restore/semi_auto/forms.py
    views/bundle/restore/semi_auto/helpers.py
    views/bundle/restore/semi_auto/step_controllers.py
    views/bundle/restore/semi_auto/step_forms.py
    views/bundle/restore/semi_auto/__init__.py
    views/bundle/restore/__init__.py
    views/bundle/security/controllers.py
    views/bundle/security/helpers.py
    views/bundle/security/__init__.py
    views/bundle/session/controllers.py
    views/bundle/session/forms.py
    views/bundle/session/__init__.py
    views/bundle/social/base.py
    views/bundle/social/controllers.py
    views/bundle/social/copier.py
    views/bundle/social/exceptions.py
    views/bundle/social/forms.py
    views/bundle/social/__init__.py
    views/bundle/states.py
    views/bundle/suggest/controllers.py
    views/bundle/suggest/forms.py
    views/bundle/suggest/__init__.py
    views/bundle/support_code/__init__.py
    views/bundle/support_code/controllers.py
    views/bundle/support_code/exceptions.py
    views/bundle/support_code/forms.py
    views/bundle/takeout/controllers.py
    views/bundle/takeout/exceptions.py
    views/bundle/takeout/forms.py
    views/bundle/takeout/__init__.py
    views/bundle/track/controllers.py
    views/bundle/track/forms.py
    views/bundle/track/__init__.py
    views/bundle/utils.py
    views/bundle/validate/controllers.py
    views/bundle/validate/forms.py
    views/bundle/validate/__init__.py
    views/bundle/webauthn/controllers.py
    views/bundle/webauthn/exceptions.py
    views/bundle/webauthn/forms.py
    views/bundle/webauthn/__init__.py
    views/bundle/yakey_backups/controllers.py
    views/bundle/yakey_backups/forms.py
    views/bundle/yakey_backups/phone_confirmation.py
    views/bundle/yakey_backups/__init__.py
    views/bundle/__init__.py
    views/captcha.py
    views/grants.py
    views/oauth.py
    views/phone_confirmation.py
    views/ping.py
    views/register.py
    views/session.py
    views/subscription.py
    views/suggest.py
    views/track.py
    views/validation.py
    views/views.py
    views/__init__.py
    yasms/api.py
    yasms/controllers/base.py
    yasms/controllers/check_phone.py
    yasms/controllers/check_user.py
    yasms/controllers/confirm.py
    yasms/controllers/delete_phone.py
    yasms/controllers/drop_phone.py
    yasms/controllers/have_user_once_validated_phone.py
    yasms/controllers/prolong_valid.py
    yasms/controllers/register.py
    yasms/controllers/remove_user_phones.py
    yasms/controllers/user_phones.py
    yasms/controllers/validations_number_of_user_phones.py
    yasms/controllers/__init__.py
    yasms/errors/base.py
    yasms/errors/confirm.py
    yasms/errors/drop_phone.py
    yasms/errors/prolong_valid.py
    yasms/errors/register.py
    yasms/errors/remove_user_phones.py
    yasms/errors/__init__.py
    yasms/exceptions.py
    yasms/forms.py
    yasms/grants.py
    yasms/serializers.py
    yasms/utils.py
    yasms/__init__.py
    __init__.py
)

RESOURCE(
    configs/base.yaml           /etc/yandex/passport-api/base.yaml
    configs/development.yaml    /etc/yandex/passport-api/development.yaml
    configs/devserver.yaml      /etc/yandex/passport-api/devserver.yaml
    configs/docker.yaml         /etc/yandex/passport-api/docker.yaml
    configs/plus.yaml           /etc/yandex/passport-api/plus.yaml
    configs/production.yaml     /etc/yandex/passport-api/production.yaml
    configs/rc.yaml             /etc/yandex/passport-api/rc.yaml
    configs/stress.yaml         /etc/yandex/passport-api/stress.yaml
    configs/testing.yaml        /etc/yandex/passport-api/testing.yaml

    templates/mail/account_hint_notification.html                           templates/mail/account_hint_notification.html
    templates/mail/app_passwords_disabled_notification.html                 templates/mail/app_passwords_disabled_notification.html
    templates/mail/app_passwords_enabled_notification.html                  templates/mail/app_passwords_enabled_notification.html
    templates/mail/auth_by_key_link_message_body.html                       templates/mail/auth_by_key_link_message_body.html
    templates/mail/auth_challenge_notification.html                         templates/mail/auth_challenge_notification.html
    templates/mail/auth_notification.html                                   templates/mail/auth_notification.html
    templates/mail/base.html                                                templates/mail/base.html
    templates/mail/confirmation_code_for_account_deletion.html              templates/mail/confirmation_code_for_account_deletion.html
    templates/mail/email_confirmation_message.html                          templates/mail/email_confirmation_message.html
    templates/mail/email_deletion_message.html                              templates/mail/email_deletion_message.html
    templates/mail/email_magic_link_base.html                               templates/mail/email_magic_link_base.html
    templates/mail/email_magic_link_for_auth_confirmed.html                 templates/mail/email_magic_link_for_auth_confirmed.html
    templates/mail/email_magic_link_for_auth_sent.html                      templates/mail/email_magic_link_for_auth_sent.html
    templates/mail/email_magic_link_for_registration_sent.html              templates/mail/email_magic_link_for_registration_sent.html
    templates/mail/email_registration_confirmation_message.html             templates/mail/email_registration_confirmation_message.html
    templates/mail/email_restoration_message_body.html                      templates/mail/email_restoration_message_body.html
    templates/mail/email_restoration_message_body_simple.txt                templates/mail/email_restoration_message_body_simple.txt
    templates/mail/email_validation_link_message.html                       templates/mail/email_validation_link_message.html
    templates/mail/email_validation_link_message_new.html                   templates/mail/email_validation_link_message_new.html
    templates/mail/oauth_client_edited_notification.html                    templates/mail/oauth_client_edited_notification.html
    templates/mail/family_invite_email.html                                 templates/mail/family_invite_email.html
    templates/mail/otp_disabled_notification.html                           templates/mail/otp_disabled_notification.html
    templates/mail/otp_disabled_on_restore_notification.html                templates/mail/otp_disabled_on_restore_notification.html
    templates/mail/otp_enabled_notification.html                            templates/mail/otp_enabled_notification.html
    templates/mail/password_change_notification.html                        templates/mail/password_change_notification.html
    templates/mail/phone_alias_as_email_disabled_by_you.html                templates/mail/phone_alias_as_email_disabled_by_you.html
    templates/mail/phone_alias_as_email_enabled.html                        templates/mail/phone_alias_as_email_enabled.html
    templates/mail/phone_alias_as_login_and_email_disabled_by_somebody.html templates/mail/phone_alias_as_login_and_email_disabled_by_somebody.html
    templates/mail/phone_alias_as_login_and_email_disabled_by_you.html      templates/mail/phone_alias_as_login_and_email_disabled_by_you.html
    templates/mail/phone_alias_as_login_and_email_enabled.html              templates/mail/phone_alias_as_login_and_email_enabled.html
    templates/mail/phone_alias_as_login_disabled_by_somebody.html           templates/mail/phone_alias_as_login_disabled_by_somebody.html
    templates/mail/phone_alias_as_login_disabled_by_you.html                templates/mail/phone_alias_as_login_disabled_by_you.html
    templates/mail/phone_alias_base.html                                    templates/mail/phone_alias_base.html
    templates/mail/phone_alias_mail_base.html                               templates/mail/phone_alias_mail_base.html
    templates/mail/phone_alias_notification.html                            templates/mail/phone_alias_notification.html
    templates/mail/phone_alias_register.html                                templates/mail/phone_alias_register.html
    templates/mail/phone_removal_started.html                               templates/mail/phone_removal_started.html
    templates/mail/phone_secured.html                                       templates/mail/phone_secured.html
    templates/mail/phone_secured_passwordless.html                          templates/mail/phone_secured_passwordless.html
    templates/mail/reset_display_name.html                                  templates/mail/reset_display_name.html
    templates/mail/restore_passed_by_email_notification.html                templates/mail/restore_passed_by_email_notification.html
    templates/mail/restore_passed_by_hint_notification.html                 templates/mail/restore_passed_by_hint_notification.html
    templates/mail/restore_passed_by_phone_notification.html                templates/mail/restore_passed_by_phone_notification.html
    templates/mail/restore_passed_by_semi_auto_form_notification.html       templates/mail/restore_passed_by_semi_auto_form_notification.html
    templates/mail/secure_phone_removed_without_quarantine.html             templates/mail/secure_phone_removed_without_quarantine.html
    templates/mail/secure_phone_removed_with_quarantine.html                templates/mail/secure_phone_removed_with_quarantine.html
    templates/mail/secure_phone_replaced.html                               templates/mail/secure_phone_replaced.html
    templates/mail/secure_phone_replacement_started.html                    templates/mail/secure_phone_replacement_started.html
    templates/mail/semi_auto_otrs_message_body.txt                          templates/mail/semi_auto_otrs_message_body.txt
    templates/mail/takeout_extract_complete.html                            templates/mail/takeout_extract_complete.html
    templates/mail/takeout_extract_requested.html                           templates/mail/takeout_extract_requested.html
    templates/mail/user_approve_message.txt                                 templates/mail/user_approve_message.txt
    templates/mail/email_code_sent.html                                     templates/mail/email_code_sent.html
)

ENDIF()

END()

IF (NOT OS_WINDOWS)
    RECURSE(
        bin
        password_blacklist/cli
        settings
        settings_override
        templates
    )

    RECURSE_FOR_TESTS(
        tests
        deb/xunistater/etc/yandex/passport-xunistater
    )
ENDIF()
