# -*- coding: utf-8 -*-

# FIXME Сейчас, когда в перловый Я.Смс передаётся код 0, он отвечает статусом
# NOCODE. Здесь продублировано такое поведение. Но это неправильно, на такой
# код следует отвечать, что код неправильный (если так оно и есть).
# Исправить, когда перестанем ходить в перловый confirm.

from datetime import datetime

import elementflow
from passport.backend.api.views.bundle.mixins.kolmogor import KolmogorMixin
from passport.backend.api.views.bundle.mixins.push import BundlePushMixin
from passport.backend.api.yasms import (
    exceptions as yasms_exceptions,
    grants,
    serializers,
)
from passport.backend.api.yasms.errors import confirm as errors
from passport.backend.api.yasms.forms import (
    ConfirmationCodeValidator,
    NormalizablePhoneNumberValidator,
    PhoneIdValidator,
    RequiredSenderForm,
)
from passport.backend.api.yasms.utils import (
    aliasify,
    get_account_by_uid,
)
from passport.backend.core import validators
from passport.backend.core.builders.yasms.utils import normalize_phone_number
from passport.backend.core.exceptions import UnknownUid
from passport.backend.core.logging_utils.loggers import StatboxLogger
from passport.backend.core.runner.context_managers import UPDATE
from passport.backend.core.yasms.unbinding import unbind_old_phone
from six import BytesIO

from .base import YasmsXmlView


class ConfirmForm(RequiredSenderForm):
    uid = validators.Uid()
    code = ConfirmationCodeValidator()
    number = NormalizablePhoneNumberValidator(not_empty=False, if_empty=None, if_missing=None)
    phoneid = PhoneIdValidator(not_empty=False, if_empty=None, if_missing=None)

    chained_validators = [
        validators.RequireSome(
            [u'number', u'phoneid'],
            min_=1,
            max_=2,
            rule_name=u'number_or_phoneid',
        ),
    ]


class ConfirmView(YasmsXmlView, BundlePushMixin, KolmogorMixin):
    required_grants = (grants.REGISTRATOR,)
    basic_form = ConfirmForm
    sensitive_fields = (u'number',)

    _root_form = RequiredSenderForm

    _errors = errors

    def process_request(self):
        self.track_id = None
        try:
            account = get_account_by_uid(self.form_values[u'uid'], self.blackbox)
            self.account = account
        except UnknownUid:
            raise self._errors.ImpossibleConfirm()

        phone_number = self.form_values[u'number']
        if phone_number is not None:
            phone_number = normalize_phone_number(phone_number)

        statbox = StatboxLogger(
            action=u'confirm',
            consumer=self.form_values[u'sender'],
            ip=self.client_ip,
        )

        timestamp = datetime.now()
        with UPDATE(
            account,
            self.request.env,
            {
                u'action': u'confirm',
                u'consumer': self.form_values[u'sender'],
            },
            datetime_=timestamp,
            initiator_uid=account.uid,
        ):
            try:
                response, flags = self.yasms.confirm(
                    account,
                    self.form_values[u'code'],
                    phone_number=phone_number,
                    phone_id=self.form_values[u'phoneid'],
                    statbox=statbox,
                    consumer=self.form_values[u'sender'],
                    event_timestamp=timestamp,
                    user_ip=self.client_ip,
                    user_agent=self.user_agent,
                )
            except yasms_exceptions.YaSmsImpossibleConfirm:
                raise self._errors.ImpossibleConfirm()
            except yasms_exceptions.YaSmsCodeLimitError:
                raise self._errors.ValidationLimit()
            finally:
                statbox.dump_stashes()

        if response[u'is_valid'] and account.phones.all():
            phone = account.phones.by_id(response[u'id'])
            if flags.aliasify:
                aliasify(
                    account,
                    phone.number,
                    self.blackbox,
                    statbox,
                    self.form_values[u'sender'],
                    u'confirm',
                )

            unbind_old_phone(
                subject_phone=phone,
                blackbox_builder=self.blackbox,
                statbox=statbox,
                consumer=self.form_values[u'sender'],
                event_timestamp=timestamp,
                environment=self.request.env,
            )

        self.response_values.update({
            u'id': response[u'id'],
            u'number': response[u'phone_number'],
            u'uid': response[u'uid'],
            u'valid': response[u'is_valid'],
            u'current': response[u'is_current'],
            u'left': response[u'code_checks_left'],
        })

    @classmethod
    def format_response(cls, response):
        return build_confirm_xml(**response)


def build_confirm_xml(id, number, uid, valid, current, left):
    out = BytesIO()
    with elementflow.xml(out, u'doc') as doc:
        doc.element(
            u'phone',
            attrs={
                u'id': serializers.number_to_str(id),
                u'number': number or u'',
                u'uid': serializers.number_to_str(uid),
                u'valid': serializers.bool_to_onezero(valid),
                u'current': serializers.bool_to_onezero(current),
                u'left': serializers.number_to_str(left),
            },
        )
    xml = out.getvalue()
    return xml
