# -*- coding: utf-8 -*-


class BaseError(Exception):
    code = None
    message = None
    http_status_code = 200

    def __init__(self, message=None):
        if message is not None:
            self.message = message


class DontKnowYou(BaseError):
    code = u'DONTKNOWYOU'
    message = u"I don't know you"


class NoRights(BaseError):
    code = u'NORIGHTS'
    message = u'Not enough rights'


class NoSender(BaseError):
    code = u'NOSENDER'
    message = u'No sender defined'


class BadPhone(BaseError):
    code = u'BADPHONE'
    message = u'Bad phone number format'


class NoPhone(BaseError):
    code = u'NOPHONE'
    message = u'No such phone'


class NoUid(BaseError):
    code = u'NOUID'
    message = u'User ID not specified'


class NoUser(BaseError):
    code = u'NOUSER'
    message = u'User not found'


class BadArg(BaseError):
    code = u'INTERROR'
    message_fmt = u'%(arg)s is invalid'

    def __init__(self, arg_name):
        self.message = self.message_fmt % {u'arg': arg_name}


class CantHaveSecureNumber(BaseError):
    code = u'CANT_HAVE_SECURE_NUMBER'
    message = u'User without password cannot have secure number'


class NumberExists(BaseError):
    code = u'NUMEXISTS'
    message = u'Number already exists'


class SecureNumberExists(BaseError):
    code = u'SECURE_NUMBER_EXISTS'
    message = u'User already has valid secure number'


class ValidationLimit(BaseError):
    code = u'VALEXEEDED'
    message = u'Max validations exeeded'


class NoRoute(BaseError):
    code = u'NOROUTE'
    message = u'No route to number'


class PhoneNumberBlockedPermanently(BaseError):
    code = u'PERMANENTBLOCK'
    message = u'Number permanently blocked'


class PhoneNumberBlockedTemporarily(BaseError):
    code = u'TEMPORARYBLOCK'
    message = u'Number temporary blocked'


class BadTsFormat(BaseError):
    code = u'BADTSFORMAT'
    message = u'Bad timestamp format'


class NoPhoneId(BaseError):
    code = u'INTERROR'
    message = u'Phone id is invalid'


class NoCode(BaseError):
    code = u'NOCODE'
    message = u'Code not specified'


class ImpossibleConfirm(BaseError):
    code = u'INTERROR'
    message = u'Impossible to confirm the phone number'


class InternalError(BaseError):
    code = u'INTERROR'
    message = u'Internal error'


class OperationExpired(BaseError):
    code = u'INTERROR'
    message = u'Operation is expired'


class DatabaseError(BaseError):
    code = u'INTERROR'
    message = u'Database error'
