# -*- coding: utf-8 -*-

from .base import *


class NoUid(BaseError):
    message = u"Can't found uid"


class DontKnowYou(BaseError):
    http_status_code = 404
    message = u"Don't know you"


class NoRights(BaseError):
    http_status_code = 404
    message = u'Not enough rights'


class NoSender(BaseError):
    http_status_code = 404
    message = u'No sender defined'


class DatabaseError(BaseError):
    message = u'Internal error'
